/* exported mc_redirect_box_date_to_hardware */
/* exported mc_level_type_dispatch_pixel_control_information_to_hardware */
/* exported mc_set_hardware_connection_library */
/* exported mc_send_box_basic_date */
/* exported mc_read_hardware_date */
/* exported mc_get_mod_date */
/* exported mc_get_dispchip_register_infor_scan */
/* exported mc_scan_dispatch_pixel_control_information_to_hardware */
/* exported mc_set_gray_get_box_base */
/* exported mc_box_date_change */
/* exported mc_wizard_get_recvcard_base */
/* exported mc_wizard_set_box_connect_infor */
/* exported mc_wizard_test_set_recvcard_to_sdk */
/* exported mc_wizard_set_gray_number */
/* exported mc_adjust_set_box */
/* exported mc_modwizd_construction_mod_xml */
/* exported mc_modwizd_access_set_mod_file */
/* exported mc_txgrp_mode_one */

/* global $ */

/* global mc_try_calculate */
/* global mc_sdk_req_mgr */
/* global mc_sdk_param */
/* global mc_sdk_module */
/* global mc_sdk_recvcard */
/* global mc_loading_wait_remove */
/* global mc_loading_wait */


var JSON_PAPRAM_GET = "GET_PARAM";
var JSON_PAPRAM_SET = "SET_PARAM";


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    发送箱体灯串显示数据重定向
 * 参数:
 *    @param {Promise<string>} str_param_val 命令行
 *    @param {Promise<string>} str_box_name 设置参数章节设置的箱体名称
 *    @param {Promise<object>} obj_random_val 选择性参数 rgb
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(tpl_json字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.03.19
 *      内容 : 所有代码
 ************************************************************************************************/


function mc_redirect_box_date_to_hardware(str_param_val, str_box_name, obj_random_val, fun_callback) {
    if ("function" !== typeof (fun_callback)) {
        return;
    }
    var str_item_obj_req = new mc_sdk_param();
    var str_attr_val = "(-1:0)";

    if (obj_random_val) {
        var length = Math.ceil((255 / Number(obj_random_val.idx_dr)));

        str_attr_val = "(-1:1)";
        for (var i = 0; i <= length; i++) {
            str_attr_val += ",(";
            str_attr_val += (Number(obj_random_val.idx_row) + Number(i * obj_random_val.idx_dr)).toString();
            str_attr_val += ":0)";
            if (255 < Number(obj_random_val.idx_row) + Number(i * obj_random_val.idx_dr)) {
                str_attr_val = str_attr_val.slice(0, -8);
                break;
            }
        }
    }

    str_item_obj_req.set_param_clear();

    str_item_obj_req.set_func("DSP_REDIRECT");
    str_item_obj_req.set_cmd(JSON_PAPRAM_SET);
    str_item_obj_req.set_param_value(str_box_name, str_param_val);
    str_item_obj_req.set_attr_val(str_box_name, "CMD", str_attr_val);
    $.post("/access_shell", str_item_obj_req.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        fun_callback();
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    发送箱体像素控制信息
 * 参数:
 *    @param {Promise<string>} str_param_val 命令行
 *    @param {Promise<string>} str_box_name 设置参数章节设置的箱体名称
 *    @param {Promise<string>} str_scan_val   选择性参数(行扫)
 *    @param {Promise<string>} str_rgb_val   选择性参数(rgb)
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(tpl_json字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.03.20
 *      内容 : 所有代码
 ************************************************************************************************/


function mc_scan_dispatch_pixel_control_information_to_hardware(str_param_val, str_box_name, str_scan_val, str_rgb_val, fun_callback) {
    if ("function" !== typeof (fun_callback)) {
        return;
    }
    var str_item_obj_req = new mc_sdk_param();
    var str_attr_val = "(255:0:-1:-1)";

    if (str_scan_val && 0 < str_scan_val.length) {
        str_attr_val = "(0:0:-1:-1),(255:0:" + str_scan_val + ":-1)";
    }
    if (str_rgb_val) {
        str_attr_val = "(255:" + str_rgb_val + ":-1:-1),(0:" + (Number(str_rgb_val) + 1) + ":-1:-1)";
    }

    str_item_obj_req.set_param_clear();
    str_item_obj_req.set_func("PIX_SWITCH");
    str_item_obj_req.set_cmd(JSON_PAPRAM_SET);
    str_item_obj_req.set_param_value(str_box_name, str_param_val);
    str_item_obj_req.set_attr_val(str_box_name, "CMD", str_attr_val);
    $.post("/access_shell", str_item_obj_req.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        fun_callback();
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    发送箱体像素控制信息(单行)
 * 参数:
 *    @param {Promise<string>} str_box_name 箱体名称
 *    @param {Promise<string>} str_order 命令行
 *    @param {Promise<object>} obj_param 参数 (点击的当前颜色系数,串行类型)
 *    @param {Promise<Number>} ui_scan_len 参数 单扫长度
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(tpl_json字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.03.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_txgrp_mode_one(str_box_name, str_order, obj_param, ui_scan_len, fun_callback) {
    if ("function" !== typeof (fun_callback)) {
        return;
    }
    var str_item_obj_req = new mc_sdk_param();
    // 下发数值减1
    var ui_reduce_one = ui_scan_len - 1;

    var idx_test_select = Number(obj_param.idx_dr);
    var idx_mode_serial = Number(obj_param.idx_row);
    var str_attr_val = "(0:-1:-1:-1)";
    var str_basic_val = ",(255:-1:-1:";
    var str_recmond_val = "(0:-1:-1:-1),(" + ui_reduce_one + ":-1:-1:)";
    var arr_param = "";
    var str_param = "";
    var b_next = true;
    var b_out = false;
    var len = Math.ceil(ui_scan_len / idx_mode_serial / 3);
    // var arr_final_val = "";
    // var str_final_val = "";

    for (var idx_grp = 0; idx_grp < len; idx_grp++) {
        b_next = true;
        for (var idx_parp = 0; idx_parp < idx_mode_serial; idx_parp++) {
            // 确定最后个参数的最后个数值
            arr_param = (str_recmond_val.split(",")[str_recmond_val.split(",").length - 1]).slice(1, -1).split(":");
            str_param = arr_param[arr_param.length - 1];
            str_attr_val += str_basic_val;

            // 第二组开始赋值 每一轮使用一次
            if (0 < idx_grp && b_next) {
                str_param = (idx_mode_serial * 2 + Number(str_param));
                b_next = false;
            }

            if (0 === Number(str_param) && "0" !== str_param) {
                // 生成第一个参数
                str_attr_val += (idx_test_select * idx_mode_serial);
            } else {
                // 生成可能连续的点
                str_attr_val += (Number(str_param) + 1);
            }

            str_attr_val += ")";
            str_recmond_val = str_attr_val;

            // 校验  待定-------------------------------------------
            // arr_final_val = str_attr_val.split(',')[str_attr_val.split(',').length - 1].slice(1, -1).split(":");
            // str_final_val = arr_final_val[3];
            if (ui_reduce_one < Number(str_param) + 1) {
                var arr_date = str_attr_val.split(",");

                arr_date.pop();
                str_attr_val = arr_date.toString();
                b_out = true;
                break;
            }
        }
        if (b_out) {
            break;
        }
    }


    str_item_obj_req.set_param_clear();
    str_item_obj_req.set_func("PIX_SWITCH");
    str_item_obj_req.set_cmd(JSON_PAPRAM_SET);
    str_item_obj_req.set_param_value(str_box_name, str_order);
    str_item_obj_req.set_attr_val(str_box_name, "CMD", str_attr_val);
    $.post("/access_shell", str_item_obj_req.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback();
            return;
        }
        fun_callback();
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置硬件链接库
 * 参数:
 *    @param {Promise<function>} fun_callback 回调函数
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.3.18
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_set_hardware_connection_library(fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var obj_sdk_param_req = new mc_sdk_param();

    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_func("HW_CONNECT_LIB");
    obj_sdk_param_req.set_cmd(JSON_PAPRAM_SET);
    obj_sdk_param_req.set_param_value("FILE", "");
    obj_sdk_param_req.set_attr_val("FILE", "BLOCK_MS", "5000");
    $.post("/access_shell", obj_sdk_param_req.get_json(), function (_response, status) {
        if ("success" !== status) {
            return;
        }
        obj_sdk_param_req.set_param_clear();
        obj_sdk_param_req.set_json(_response);
        // var str_box_basic_date = obj_sdk_param_req.get_param_value("ERROR_CODE");

        fun_callback();
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取模组信息
 * 参数:
 *    @param {Promise<function>} fun_callback 回调函数
 *    @param {Promise<string>} str_mod_name 模组名称
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.3.20
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_get_mod_date(str_mod_name, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var obj_sdk_param_req = new mc_sdk_param();

    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_func("MOD_FILE");
    obj_sdk_param_req.set_cmd(JSON_PAPRAM_GET);
    obj_sdk_param_req.set_param_value(str_mod_name, "");

    $.post("/access_shell", obj_sdk_param_req.get_json(), function (_response, status) {
        if ("success" !== status) {
            return;
        }
        obj_sdk_param_req.set_param_clear();
        obj_sdk_param_req.set_json(_response);
        var str_mod_date = obj_sdk_param_req.get_param_value(str_mod_name);

        fun_callback(str_mod_date);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取显示芯片注册信息 最大行扫数
 * 参数:
 *    @param {Promise<string>} str_ctrlchip 控制芯片名称,不能为空
 *    @param {Promise<string>} str_dispchip 显示芯片名称,不能为空
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(tpl_json字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.03.20
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_get_dispchip_register_infor_scan(str_info_json, str_dispchip) {
    if ("string" !== typeof str_info_json || 0 >= str_info_json.length) {
        return false;
    }
    if ("string" !== typeof str_dispchip || 0 >= str_dispchip.length) {
        return false;
    }
    var str_item_json_req = new mc_sdk_param();

    str_item_json_req.set_param_clear();
    str_item_json_req.set_json(str_info_json);
    var str_scan_max_count = str_item_json_req.get_attr_val(str_dispchip, "MAX_SCAN_ROWS");

    return str_scan_max_count;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    修改灰阶度 只适用于本文件的html
 * 参数:
 *    @param {Promise<string>} str_gray_bit 灰阶,不能为空
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(tpl_json字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.03.25
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_wizard_set_gray_number(str_gray_bit, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("NORMAL");
    obj_sdk_param.set_cmd("SET_PARAM");
    obj_sdk_param.set_param_value("GRAY_BIT_SIZE", str_gray_bit);
    $.post("/access_shell", obj_sdk_param.get_json(), function (_response, status) {
        if ("success" !== status) {
            fun_callback();
            return;
        }

        fun_callback();
        return;
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读取箱体基础数据
 * 参数:
 *    @param {Promise<string>} str_box_name 箱体名称
 *    @param {Promise<function>} fun_callback 回调函数
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.3.27
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_wizard_get_recvcard_base(str_box_name, fun_callback) {
    var obj_sdk_param_req = new mc_sdk_param();

    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_func("RECVCARD_BASE");
    obj_sdk_param_req.set_cmd(JSON_PAPRAM_GET);
    obj_sdk_param_req.set_param_value(str_box_name, "");
    $.post("/access_shell", obj_sdk_param_req.get_json(), function (_response, status) {
        if ("success" !== status) {
            return;
        }
        obj_sdk_param_req.set_param_clear();
        obj_sdk_param_req.set_json(_response);
        var str_box_basic_date = obj_sdk_param_req.get_param_value(str_box_name);


        fun_callback(str_box_basic_date);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    创建设置箱体连接信息
 * 参数:
 *    @param {Promise<string>} ctrlchip_name 控制芯片名称
 *    @param {Promise<string>} str_hub_name hub接口id
 *    @param {Promise<object>} obj_appearance 外观数据
 *    @param {Promise<function>} fun_callback 回调函数
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.3.27
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_wizard_set_box_connect_infor(ctrlchip_name, str_hub_name, obj_appearance, fun_callback) {
    if ("function" !== typeof fun_callback || "string" !== typeof ctrlchip_name || 0 === ctrlchip_name.length) {
        return;
    }
    var str_box_connect_infor = "";
    var str_box_connect_xml = new mc_sdk_recvcard();
    // var str_group = obj_appearance.PARAMS[4].VALUE;
    // var str_group_type = obj_appearance.PARAMS[5].VALUE;

    var obj_param_info = new mc_sdk_param();

    obj_param_info.set_param_clear();
    obj_param_info.set_json(JSON.stringify(obj_appearance));

    var str_group = obj_param_info.get_param_value("MC_LANG_LABLE_TXGRP_CNT");
    var str_group_type = obj_param_info.get_param_value("MC_LANG_LABLE_TXGRP_MODE");

    var ui_total = Number(str_group) * Number(str_group_type);
    var str_pin = "";

    if (1 === str_group_type) {
        ui_total = 2;
    }

    for (var idx = 0; idx < ui_total; idx++) {
        str_pin += "(DSP";
        str_pin += idx;
        str_pin += ":STR_";
        str_pin += idx;
        str_pin += "),";
    }
    str_pin = str_pin.slice(0, -1);

    str_box_connect_xml.mc_util_recvcard_set_ctrlchip_name(ctrlchip_name);
    str_box_connect_xml.mc_util_recvcard_set_hub_name(str_hub_name);
    // str_box_connect_xml.mc_util_recvcard_set_img_rotation("0.0,0.0,0.0");
    // str_box_connect_xml.mc_util_recvcard_set_img_scale("0.0,0.0,1.0");
    // str_box_connect_xml.mc_util_recvcard_set_img_offset("0.0,0.0");
    // "(DSP0:STR_0),(DSP1:STR_1),(DSP2:STR_2),(DSP3:STR_3),(DSP4:STR_4),(DSP5:STR_5),(DSP6:STR_6),(DSP7:STR_7)"
    str_box_connect_xml.mc_util_recvcard_set_modlist_pin_pair_exp(0, str_pin);
    str_box_connect_xml.mc_util_recvcard_set_modlist_mod_info(0, 0, "str_mod_text", 0, 0);
    str_box_connect_infor = str_box_connect_xml.mc_util_recvcard_get_xml();


    fun_callback(str_box_connect_infor);
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将箱体链接信息发往sdk
 * 参数:
 *    @param {Promise<string>} str_box_name 测试箱体名称
 *    @param {Promise<string>} str_box_xml 箱体链接信息xml子串
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.4.3
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_wizard_test_set_recvcard_to_sdk(str_box_name, str_box_xml, fun_callback) {
    if ("string" !== typeof str_box_xml || 0 >= str_box_xml.length) {
        fun_callback();
    }
    var obj_sdk_param_req = new mc_sdk_param();

    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_func("BOX_FILE");
    obj_sdk_param_req.set_cmd(JSON_PAPRAM_SET);
    obj_sdk_param_req.set_param_value(str_box_name, str_box_xml);
    obj_sdk_param_req.set_attr_val(str_box_name, "FILE_OPT", "SET");
    $.post("/access_shell", obj_sdk_param_req.get_json(), function (_response, status) {
        if ("success" !== status) {
            return;
        }
        fun_callback();
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    初始化模组信息
 * 参数:
 *    @param {Promise<string>} str_ctrlchip_name 主控芯片
 *    @param {Promise<string>} str_hub_name hub接口名字
 *    @param {Promise<object>} obj_test_appearance_ui_json mc_sdk_module实例对象
 *    @param {Promise<object>} obj_test_level_type_ui_json mc_sdk_module实例对象
 *    @param {Promise<object>} obj_test_scan_json mc_sdk_module实例对象
 *    @param {Promise<object>} obj_test_clr_ui_json mc_sdk_module实例对象
 *    @param {Promise<object>} g_obj_info_data mc_dispchip_reg_info实例对象
 *
 *    @param {Promise<object>} fun_callback 回调
 * 返回：
 *    @returns {Promise<Array>} obj_text_module 模组信息
 *    @returns {Promise<Array>} str_register_val 注册信息
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.4.3
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_adjust_set_box(str_ctrlchip_name, str_hub_name, obj_test_appearance_ui_json, obj_test_level_type_ui_json, obj_test_scan_json, obj_test_clr_ui_json, g_obj_info_data, fun_callback) {
    // 创建箱体连接信息
    mc_wizard_set_box_connect_infor(str_ctrlchip_name, str_hub_name, obj_test_appearance_ui_json, function (str_box_xml) {
        // 下发sdk
        mc_wizard_test_set_recvcard_to_sdk("mc_test_box", str_box_xml, function () {
            if (0 >= obj_test_appearance_ui_json.PARAMS.length) {
                mc_loading_wait_remove();
                return;
            }
            mc_modwizd_construction_mod_xml(str_ctrlchip_name, obj_test_appearance_ui_json, obj_test_level_type_ui_json, obj_test_scan_json, obj_test_clr_ui_json, g_obj_info_data, function (str_xml, str_register_val) {
                // 生成模组中
                // 试算
                mc_try_calculate(str_register_val, str_xml, function (obj_text_module) {
                    fun_callback([obj_text_module, str_register_val]);
                }, true);
            });
        });
    });
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    生成模组信息xml字符串
 * 参数:
 *    @param {Promise<Object>} str_ctrlchip_name 主控芯片名称
 *    @param {Promise<Object>} obj_appearance_ui_json 外观区域参数
 *    @param {Promise<Object>} obj_level_type_ui_json 时序极性区域参数
 *    @param {Promise<Object>} obj_scan_json 行扫区域参数
 *    @param {Promise<Object>} obj_clr_ui_json 灯串颜色区域参数
 *    @param {Promise<Object>} g_obj_info_data mc_dispchip_reg_info实例对象
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(生成的xml字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_construction_mod_xml(str_ctrlchip_name, obj_appearance_ui_json, obj_level_type_ui_json, obj_scan_json, obj_clr_ui_json, g_obj_info_data, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if (0 >= Object.keys(obj_appearance_ui_json).length) {
        fun_callback("");
        return;
    }
    if (0 >= Object.keys(obj_scan_json).length) {
        fun_callback("");
        return;
    }
    if (0 >= Object.keys(obj_clr_ui_json).length) {
        fun_callback("");
        return;
    }
    var OBJ_SDK_PARAM_RES = new mc_sdk_param();
    // var str_ctrlchip = "";
    var str_dispchip = "";
    var str_param_name = "";
    var str_param_value = "";

    OBJ_SDK_PARAM_RES.set_param_clear();
    OBJ_SDK_PARAM_RES.set_json(JSON.stringify(obj_appearance_ui_json));
    // str_ctrlchip = str_ctrlchip_name;
    str_param_name = "MC_LANG_DISPCHIP_LIST";
    str_dispchip = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);

    // mc_modwizd_dispchip_register_info_by_sdk(str_ctrlchip, str_dispchip, function (str_register_json) {
    g_obj_info_data.get_info_json(function (str_register_json) {
        OBJ_SDK_PARAM_RES.set_param_clear();
        OBJ_SDK_PARAM_RES.set_json(str_register_json);
        var obj_module_xml = new mc_sdk_module();
        var ui_weight_val = 0;
        var ui_txgrp_cnt_val = 0;
        var ui_txgrp_mode_val = 0;
        var str_pix_step_val = OBJ_SDK_PARAM_RES.get_attr_val(str_dispchip, "JUMP_IC");

        str_param_value = "1";
        if ("0" !== str_pix_step_val) {
            str_param_value = OBJ_SDK_PARAM_RES.get_attr_val(str_dispchip, "IC_CHANNELS");
        }
        obj_module_xml.mc_util_mod_set_scan_pix_step(str_param_value);
        OBJ_SDK_PARAM_RES.set_param_clear();
        OBJ_SDK_PARAM_RES.set_json(JSON.stringify(obj_appearance_ui_json));
        str_param_name = "MC_LANG_LABLE_WEITH";
        ui_weight_val = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);
        ui_weight_val = Number(ui_weight_val);
        obj_module_xml.mc_util_mod_set_width(ui_weight_val);
        str_param_name = "MC_LANG_LABLE_HEIGHT";
        str_param_value = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);
        str_param_value = Number(str_param_value);
        obj_module_xml.mc_util_mod_set_height(str_param_value);
        str_param_name = "MC_LANG_LABLE_TXGRP_CNT";
        ui_txgrp_cnt_val = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);
        ui_txgrp_cnt_val = Number(ui_txgrp_cnt_val);
        str_param_name = "MC_LANG_DISPCHIP_LIST";
        str_param_value = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);
        obj_module_xml.mc_util_mod_set_disp_chip(str_param_value);
        str_param_name = "MC_LANG_SCANCHIP_LIST";
        str_param_value = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);
        obj_module_xml.mc_util_mod_set_scan_chip(str_param_value);
        str_param_name = "MC_LANG_LABLE_TXGRP_MODE";
        str_param_value = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);
        ui_txgrp_mode_val = str_param_value;
        ui_txgrp_mode_val = Number(ui_txgrp_mode_val);
        obj_module_xml.mc_util_mod_set_str_grp_mode(str_param_value);

        str_param_name = "MC_LANG_LABLE_CLOSE_LOW_VALID";
        str_param_value = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);
        var b_close_val = false;

        if (Number(str_param_value)) {
            b_close_val = true;
        }
        obj_module_xml.mc_util_mod_set_close_low_valid(b_close_val);

        str_param_name = "MC_LANG_LABLE_LED_GRP_MODE";
        str_param_value = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);
        var ui_led_mod_val = Number(str_param_value);

        obj_module_xml.mc_util_mod_set_sclk_pin_name(0, "SCLK");
        var ui_param_cnt = OBJ_SDK_PARAM_RES.get_param_cnt();
        var ui_sclk_sub = 1;
        var ary_sclk_val = [];

        for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
            str_param_name = OBJ_SDK_PARAM_RES.get_param_name(idx_param);

            if (-1 !== str_param_name.indexOf("MC_LANG_LABLE_SCLK")) {
                str_param_value = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);
                if ("MC_LANG_OPTION_NOT_USE" === str_param_value) {
                    break;
                }
                if (-1 !== ary_sclk_val.indexOf(str_param_value)) {
                    continue;
                }
                ary_sclk_val.push(str_param_value);
                obj_module_xml.mc_util_mod_set_sclk_pin_name(ui_sclk_sub, str_param_value);
                ui_sclk_sub++;
            }
        }

        OBJ_SDK_PARAM_RES.set_param_clear();
        OBJ_SDK_PARAM_RES.set_json(JSON.stringify(obj_level_type_ui_json));
        str_param_name = "MC_LANG_LABLE_OE_LOW_VALID";
        str_param_value = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);
        if ("string" === typeof str_param_value) {
            obj_module_xml.mc_util_mod_set_oe_low_valid(parseInt(str_param_value, 10));
        }
        str_param_name = "MC_LANG_LABLE_TX_LOW_VALID";
        str_param_value = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);
        obj_module_xml.mc_util_mod_set_tx_low_valid(0);
        if ("string" === typeof str_param_value) {
            obj_module_xml.mc_util_mod_set_tx_low_valid(parseInt(str_param_value, 10));
        }
        var ui_pix_str_cnt = ui_txgrp_cnt_val * ui_txgrp_mode_val;

        for (var idx_pix_str = 0; idx_pix_str < ui_pix_str_cnt; idx_pix_str++) {
            obj_module_xml.mc_util_mod_set_str_name(idx_pix_str, "STR_" + idx_pix_str);
            obj_module_xml.mc_util_mod_set_str_pin(idx_pix_str, "STR_" + idx_pix_str);
        }
        if (1 === ui_txgrp_mode_val) {
            for (var idx_pix = 0; idx_pix < ui_led_mod_val; idx_pix++) {
                obj_module_xml.mc_util_mod_set_pix_info(0, 0, idx_pix, 0, 0, "R");
            }
        }
        fun_callback(obj_module_xml.mc_util_mod_get_xml(), str_register_json);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    生成模组信息xml字符串
 * 参数:
 *    @param {Promise<Array>} ary_mod_data 模组数据

 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(生成的xml字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.05.27
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_modwizd_access_set_mod_file(ary_mod_data, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if (0 >= ary_mod_data.length) {
        fn_callback();
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();

    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("MOD_FILE");
    obj_sdk_param.set_cmd("SET_PARAM");

    for (var idx = 0; idx < ary_mod_data.length; idx++) {
        var str_module_name = ary_mod_data[idx].name;
        var str_module_xml = ary_mod_data[idx].data;

        obj_sdk_param.set_param_value(str_module_name, str_module_xml);
        obj_sdk_param.set_attr_val(str_module_name, "FILE_OPT", "SET");
    }
    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    比较注册信息 若后来的不一样则使用后来的
 * 参数:
 *    @param {Promise<string>} str_before 模组数据
 *    @param {Promise<string>} str_after 传入回调函数,不能为空(生成的xml字串)
 * 返回：
 *    @return {Promise<boolean>} b_same ture/false
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.08.14
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_jungle_registere_info(str_before, str_after) {
    var b_same = false;

    var obj_before_param = new mc_sdk_param();
    var obj_after_param = new mc_sdk_param();

    obj_before_param.set_json(str_before);
    obj_after_param.set_json(str_after);

    var ui_param_cnt = obj_after_param.get_param_cnt();

    for (var id = 0; id < ui_param_cnt; id++) {
        var str_param_name = obj_after_param.get_param_name(id);

        if ("ERROR_CODE" === str_param_name) {
            continue;
        }

        var ui_attr_cnt = obj_after_param.get_attr_cnt(str_param_name);

        for (var idx = 0; idx < ui_attr_cnt; idx++) {
            var str_attr_name = obj_after_param.get_attr_name(str_param_name, idx);
            var str_before_val = obj_before_param.get_attr_val(str_param_name, str_attr_name);
            var str_after_val = obj_after_param.get_attr_val(str_param_name, str_attr_name);

            if (str_before_val !== str_after_val) {
                b_same = true;
                break;
            }
        }
    }
    return b_same;
}
